/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.blocks.tileentities.instances;

import minecrafttransportsimulator.baseclasses.ComputedVariable;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.blocks.tileentities.components.ATileEntityLoader;
import minecrafttransportsimulator.blocks.tileentities.components.ITileEntityFluidTankProvider;
import minecrafttransportsimulator.entities.instances.EntityFluidTank;
import minecrafttransportsimulator.entities.instances.PartInteractable;
import minecrafttransportsimulator.items.instances.ItemDecor;
import minecrafttransportsimulator.jsondefs.JSONDecor;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.InterfaceManager;

public class TileEntityFluidLoader
extends ATileEntityLoader
implements ITileEntityFluidTankProvider {
    private final EntityFluidTank tank;
    private final ComputedVariable loadingActiveVar;
    private final ComputedVariable unloadingActiveVar;

    public TileEntityFluidLoader(AWrapperWorld world, Point3D position, IWrapperPlayer placingPlayer, ItemDecor item, IWrapperNBT data) {
        super(world, position, placingPlayer, item, data);
        this.tank = new EntityFluidTank(world, data != null ? data.getData("tank") : null, ((JSONDecor)this.definition).decor.fuelCapacity);
        world.addEntity(this.tank);
        this.loadingActiveVar = new ComputedVariable(this, "tank_loading_active");
        this.addVariable(this.loadingActiveVar);
        this.unloadingActiveVar = new ComputedVariable(this, "tank_unloading_active");
        this.addVariable(this.unloadingActiveVar);
    }

    @Override
    public void remove() {
        super.remove();
        this.tank.remove();
    }

    @Override
    public ComputedVariable createComputedVariable(String variable, boolean createDefaultIfNotPresent) {
        switch (variable) {
            case "tank_buffer_active": {
                return new ComputedVariable(this, variable, partialTicks -> this.tank.getFluidLevel() > 0.0 ? 1.0 : 0.0, false);
            }
        }
        return super.createComputedVariable(variable, createDefaultIfNotPresent);
    }

    @Override
    public boolean isUnloader() {
        return ((JSONDecor)this.definition).decor.type.equals((Object)JSONDecor.DecorComponentType.FLUID_UNLOADER);
    }

    @Override
    protected boolean canOperate() {
        return this.isUnloader() ? this.tank.getFluidLevel() < (double)this.tank.getMaxLevel() : this.tank.getFluidLevel() > 0.0;
    }

    @Override
    protected boolean canLoadPart(PartInteractable part) {
        if (part.tank != null) {
            return this.isUnloader() ? part.tank.drain(this.tank.getFluid(), this.tank.getFluidMod(), 1.0, false) > 0.0 : part.tank.fill(this.tank.getFluid(), this.tank.getFluidMod(), 1.0, false) > 0.0;
        }
        return false;
    }

    @Override
    protected void doLoading() {
        String fluidModToLoad;
        String fluidToLoad = this.tank.getFluid();
        double amountToLoad = this.connectedPart.tank.fill(fluidToLoad, fluidModToLoad = this.tank.getFluidMod(), ((JSONDecor)this.definition).decor.pumpRate, false);
        if (amountToLoad > 0.0) {
            amountToLoad = this.tank.drain(fluidToLoad, fluidModToLoad, amountToLoad, true);
            this.connectedPart.tank.fill(fluidToLoad, fluidModToLoad, amountToLoad, true);
            this.loadingActiveVar.setActive(amountToLoad > 0.0, true);
            this.hasChanged = true;
        } else {
            this.updateNearestPart();
            this.loadingActiveVar.setActive(false, true);
        }
    }

    @Override
    protected void doUnloading() {
        String fluidModToUnload;
        String fluidToUnload = this.connectedPart.tank.getFluid();
        double amountToUnload = this.connectedPart.tank.drain(fluidToUnload, fluidModToUnload = this.connectedPart.tank.getFluidMod(), ((JSONDecor)this.definition).decor.pumpRate, false);
        if (amountToUnload > 0.0) {
            amountToUnload = this.tank.fill(fluidToUnload, fluidModToUnload, amountToUnload, true);
            this.connectedPart.tank.drain(fluidToUnload, fluidModToUnload, amountToUnload, true);
            this.unloadingActiveVar.setActive(amountToUnload > 0.0, true);
            this.hasChanged = true;
        } else {
            this.updateNearestPart();
            this.unloadingActiveVar.setActive(false, true);
        }
    }

    @Override
    public EntityFluidTank getTank() {
        return this.tank;
    }

    @Override
    public IWrapperNBT save(IWrapperNBT data) {
        super.save(data);
        data.setData("tank", this.tank.save(InterfaceManager.coreInterface.getNewNBTWrapper()));
        return data;
    }
}

